/* ------------------------------------------------------------------------ */
/*  @@ Source Documentation                           *** MSC Version ***   */
/*                                                                          */
/*  Copyright (c) Creative Technology Pte Ltd, 1991. All rights reserved.   */
/*                                                                          */
/*   TITLE       : DEMOVDR.C                                                */
/*                                                                          */
/*   DESCRIPTION :                                                          */
/*       This program demostrates how to perform voice recording using      */
/*       the CTVDSK.DRV driver. The voice recording is using the Disk       */
/*       Double Buffering method.                                           */
/*                                                                          */
/*       The program checks BLASTER environment for the Card settings.      */
/*       It also performs test base on BLASTER environment settings to      */
/*       ensure they are tally with the hardware settings on the Card.      */
/*                                                                          */
/*       Note that the program included the module LOADDRV.C to load        */
/*       the loadable CTVDSK.DRV into memory.                               */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#include <dos.h>
#include <bios.h>
#include <stdio.h>
#include <fcntl.h>

#include <sbc.h>
#include <sbcvoice.h>

#include  "loaddrv.c"


main ()
{
    extern  char far * near ctvdsk_drv;


    /* Retrieve the BLASTER environment settings */
    if ( ! GetEnvSetting() )
    {
        if (sbc_check_card() & 4)
        {
            if (sbc_test_int())
            {
                if (sbc_test_dma() >= 0)
                {
                    if (ctvdsk_drv = LoadDriver("CTVDSK.DRV"))
                    {
                        if ( !ctvd_init(16) )
                        {
                            RecordFile("TEMP.VOC") ;

                            ctvd_terminate() ;
                        }
                        else
                            ShowError() ;
                    }
                }
                else
                    printf("Error on DMA channel.\n");
            }
            else
                printf("Error on interrupt.\n");
        }
        else
            printf("Sound Blaster Card not found or wrong I/O settings.\n") ;
    }
    else
        printf("BLASTER environment not set or incomplete or invalid.\n");
}


/* ------------------------------------------------------------------------ */
/*  @@ Usage                                                                */
/*                                                                          */
/*   RecordFile (char *szFilename)                                          */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Record voice with the filename specified.                          */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       szFilename :- filename to be output.                               */
/*                                                                          */
/*   EXIT:                                                                  */
/*       None.                                                              */
/*                                                                          */
/* ------------------------------------------------------------------------ */

RecordFile (char *szFilename)
{
    int     Handle ;


    /* create and record a voice file */
    if ( !_dos_creat(szFilename, _A_NORMAL, &Handle) )
    {
        ctvd_speaker(0) ;

        if ( ctvd_input(Handle, 8000) == NO_ERROR )
        {
            RecordUntilStopped() ;

            if ( ctvd_drv_error() )
                ShowError() ;
            else
                printf ("Voice record ended.\n") ;
        }
        else
            ShowError () ;

        _dos_close (Handle) ;
    }
    else
        printf ("Create %s file error\n", szFilename ) ;
}


/* ------------------------------------------------------------------------ */
/*  @@ Usage                                                                */
/*                                                                          */
/*   RecordUntilStopped (void)                                              */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Starts voice recording. Press ESC key to terminate the recording.  */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       None.                                                              */
/*                                                                          */
/*   EXIT:                                                                  */
/*       None.                                                              */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#pragma loop_opt(off)	/* turn off loop optimiaztion */
RecordUntilStopped (void)
{
    unsigned    wKey ;


    /* Polls for hot key while playing voice file */
    while ( ct_voice_status )
    {
        if ( _bios_keybrd( _KEYBRD_READY ) )
        {
            /* check for ESC key */
            if ( (wKey = _bios_keybrd(_KEYBRD_READ) & 0xff) == 0x1b )
                ctvd_stop () ;
        }
    }

    printf ("Voice stopped.\n") ;
}
#pragma loop_opt()


/* ------------------------------------------------------------------------ */
/*  @@ Usage                                                                */
/*                                                                          */
/*   ShowError (void)                                                       */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Display error occurred during the process of voice I/O.            */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       None.                                                              */
/*                                                                          */
/*   EXIT:                                                                  */
/*       None.                                                              */
/*                                                                          */
/* ------------------------------------------------------------------------ */

ShowError (void)
{
    int     Err ;


    /* Show the driver error and the DOS extended error code */
    Err = ctvd_drv_error() ;

    printf("Driver error = %2d\n", Err) ;

    Err = ctvd_ext_error();
    if ( Err != 0 )
        printf ("DOS error = %2d\n", Err) ;
}
